<?php
namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
class VideoType extends AbstractType
{
   public function buildForm(FormBuilderInterface $builder, array $options)
    {
         $builder->add('title',"text",array("label"=>"Title"));
         $builder->add('description',null,array("label"=>"description"));
         $builder->add('enabled',null,array("label"=>"Enabled"));
         $builder->add('premium',null,array("label"=>"Premium"));
         $builder->add('comment',null,array("label"=>"Enabled comments"));
         $builder->add('tags',null,array("label"=>"Tags (Keywords)"));
         $builder->add('resolution',null,array("label"=>"Resolution","required"=>false));

         $builder->add("categories",'entity',
                      array(
                            'class' => 'AppBundle:Category',
                            'expanded' => true,
                            "multiple" => "true",
                            'by_reference' => false
                          )
                      );
         $builder->add("colors",'entity',
                      array(
                            'class' => 'AppBundle:Color',
                            'expanded' => true,
                            "multiple" => "true",
                            'by_reference' => false
                          )
                      );
        $builder->add("packs",'entity',
                      array(
                            'class' => 'AppBundle:Pack',
                            'expanded' => true,
                            "multiple" => "true",
                            'by_reference' => false
                          )
                      );
        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            $article = $event->getData();
            $form = $event->getForm();
            if ($article and null !== $article->getId()) {
                 $form->add("file",null,array("label"=>"","required"=>false));
                 $form->add("filevideo",null,array("label"=>"","required"=>false));
                 $form->add("color");
                 $form->add("resolution");
                 $form->add("size");

            }else{
                 $form->add("file",null,array("label"=>"","required"=>true));
                 $form->add("filevideo",null,array("label"=>"","required"=>true));
            }
        });
        $builder->add('save', 'submit',array("label"=>"save"));
      }
      public function getName()
      {
          return 'Video';
      }
}
?>